import QtQuick 2.3
import "../" // to import RocketScene
import "../_SharedQML"
import AdaptDemoSystem 1.0

RocketScene { 
  VariClock {
      id: zoomClock;
      clockSpeed: 0.3*sync("zoomPercent")
      reset: sync("zoomClock.reset")
  }
  FlyCamera { id: flyCam }
  //setup default textures
  TextureImage { textureUnit: 1; file: "../../images/_SK57414_normal.png"}
  TextureImage { textureUnit: 2; file: "../../images/area_lights.jpg"}
  Texture { textureUnit: 3; textureRT: "prev" }
  Texture { textureUnit: 4; textureRT: "prevBlur" }
  Texture { textureUnit: 5; textureRT: "prevNormal" }


  Group {
      id: bgBall
      enabled: sync("bgBall.ON")

      // bg
      Shader { file: "smBg" }
      TextureImage { textureUnit: 0; file: "../../images/kivitex1s.png"}
      TextureImage { textureUnit: 0; file: "../../images/apobg.png"}
      TextureImage { textureUnit: 0; file: "../../images/bg_metsb.png"}
      TextureImage { textureUnit: 0; file: "../../images/apo69.png"}
      TextureImage { textureUnit: 0; file: "../../images/bokeh_housus.png"}
      DrawMesh {
        file: "mesh/ball5000.x";
        // "mesh/puppet_jump.dae","mesh/Cave.dae","mesh/aivob.x","mesh/400x400.obj"
        enabled: true; smoothNormals: true; normalSmoothAngle: 20; blendMode: "off"; depthTest: true; depthWrite: true;
        //  cull: true; cullBack: true
        Sca { s: 400.0; x: 1.0; y: 10.0; z: 1.0 }
        Pos { x: 0.0; y: -0.005; z: 0.0}
        Rot { d: -90; ax: 1.0; ay: 0.0; az: 0.0 }
        ShaderParam { paramName: "g_uvScale"; paramValue: 1.0}
        ShaderParam { paramName: "g_uvScaleY"; paramValue: 1.0}
        ShaderParam { paramName: "g_uvOfsY"; paramValue: sync("bg.uvOfsY") }
        ShaderParam { paramName: "g_bump"; paramValue: 0.650}
        ShaderParam { paramName: "g_texBrightness"; paramValue: 1.0 }
        ShaderParam { paramName: "g_texAmbient"; paramValue: 0.00 }
        ShaderParam { paramName: "g_prevAmount"; paramValue: 0.0 }
        ShaderParam { paramName: "g_prevBlurAmount"; paramValue: sync("prevBlurAmount") }
        ShaderParam { paramName: "g_color"; paramValueVec4: "1.0, 1.0, 1.0, 1.0"}
        ShaderParam { paramName: "g_bright"; paramValue: 1.0}
      }
      Blit {
          textureRT: "bgBall"
      }

      //  // TODO: make BlitDepth etc. out of this!
      //  RenderTarget {
      //      RenderTargetLayer {
      //          textureRT: "bgBallDepth"
      //          format: "RGBA32F"
      //          width: demo.windowWidth
      //          height: demo.windowHeight
      ////            Clear {
      ////                cR: 0.0; cG: 0.0; cB: 0.0; cA: 1.0;
      ////            }
      //      }
      //      Texture {
      //          textureUnit: 0
      //          textureRT: "mainDepth"
      //      }
      //      Shader {
      //          file: "fx/_SharedQML/drawRtTexel"
      //      }
      //      DrawVB {
      //          type: "quad"
      //          depthTest: false
      //          depthWrite: false
      //          ShaderParam {
      //              paramName: "flip"
      //              paramValue: 1.0
      //          }
      //          blendMode: "off"
      //      }
      //  }
  }



  TextureImage {
    textureUnit: 0; file: "../../images/meteor.png";
  }
  Group {
    // big mirror plane
    Shader { file: "smInfiFade" }
    DrawMesh {
      file: "mesh/box1m.lwo"; enabled: true; smoothNormals: true; normalSmoothAngle: 20; blendMode: "normal"; depthTest: true; depthWrite: true; cull: true; cullBack: true; Pos { x: 0.0; y: -0.950; z: 0.0}
      Rot { d: 0; ax: 1.0; ay: 0.0; az: 0.0 }
      Sca { s: 10.0; x: 100.0; y: 1.0; z: 100.0 }
      ShaderParam { paramName: "g_uvScale"; paramValue: 0.50}
      ShaderParam { paramName: "g_texBrightness"; paramValue: 0.5}
      ShaderParam { paramName: "g_texAmbient"; paramValue: 0.001}
      ShaderParam { paramName: "g_bump"; paramValue: 0.250}
      ShaderParam { paramName: "g_prevAmount"; paramValue: 0.0 }
      ShaderParam { paramName: "g_prevBlurAmount"; paramValue: sync("prevBlurAmount")}
      ShaderParam { paramName: "g_color"; paramValueVec4: "1.0, 1.0, 1.10, 1.0"}
      ShaderParam { paramName: "g_bright"; paramValue: 1.0}
      ShaderParam { paramName: "g_zoomTime"; paramValue: zoomClock.time }
    }
  }
  // emitter ball shape, the actual emitter is in the end of the skene
  Shader { file: "smPlastic" }
  TextureImage { textureUnit: 0; file: "../../images/meteor.png"}
  DrawMesh {
    enabled: false; Pos { x: 2.0; y: 6.0; z: 0.50}
    Sca { s: 6.0}
    file: "mesh/ball5000.x"; depthWrite: true; blendMode: "off"; ShaderParam { paramName: "g_uvScale"; paramValue: 0.30}
    ShaderParam { paramName: "g_bump"; paramValue: 0.50}
    ShaderParam { paramName: "g_texBrightness"; paramValue: 0.02 }
    ShaderParam { paramName: "g_texAmbient"; paramValue: 0.0020 }
    ShaderParam { paramName: "g_prevAmount"; paramValue: 0.0 }
    ShaderParam { paramName: "g_prevBlurAmount"; paramValue: sync("prevBlurAmount") }
    ShaderParam { paramName: "g_color"; paramValueVec4: "2.0, 1.50, 1.0, 1.0"}
    ShaderParam { paramName: "g_bright"; paramValue: 1.0}
  }
  // mirror ball
  Shader { file: "smPackInt" }
  DrawMesh {
    file: "mesh/ball5000.x";
    // "mesh/puppet_jump.dae","mesh/Cave.dae","mesh/aivob.x","mesh/400x400.obj"
    enabled: true; smoothNormals: true; normalSmoothAngle: 20; blendMode: "off"; depthTest: true; depthWrite: true;
    halfFloats: true
    intPack: true
    //  cull: true; cullBack: true
    Sca { s: 10.0; x: 1.0; y: 1.0; z: 1.0 }
    Pos { x: 0.0; y: -0.005; z: 0.0}
    Rot { d: -90; ax: 1.0; ay: 0.0; az: 0.0 }
    ShaderParam { paramName: "g_uvScale"; paramValue: 1.5}
    ShaderParam { paramName: "g_bump"; paramValue: 0.650}
    ShaderParam { paramName: "g_texBrightness"; paramValue: 0.01 }
    ShaderParam { paramName: "g_texAmbient"; paramValue: 0.00 }
    ShaderParam { paramName: "g_prevAmount"; paramValue: 0.0 }
    ShaderParam { paramName: "g_prevBlurAmount"; paramValue: sync("prevBlurAmount") }
    ShaderParam { paramName: "g_color"; paramValueVec4: "1.0, 1.0, 1.0, 1.0"}
    ShaderParam { paramName: "g_bright"; paramValue: 1.0}
  }

 Shader { file: "smPlastic" }

  //grower emit, advance & draw

  Group {
      id: boxGrower
      name: "boxGrower"
      enabled: sync(boxGrower.name+".ON")

      // diffuse texture
      TextureImage { textureUnit: 0; file: "../../images/apo69.png"}

      // from root to leaves emit time based swipe palette triggered with swipe.trigger track
      TextureImage { textureUnit: 1; file: "../../images/palette_shot8.png"}

      // time since birth / age based swiper palette
      TextureImage { textureUnit: 2; file: "../../images/palette_shot1.png"}

      // palette gradient defining the grow "plane" (if one of the moveX, Y or Z is set to zero or near zero).
      // Applied with amplitude .grow.movePalAmp and the x offset in palette image is moved in time with
      // .grow.movePalFreq, .grow.movePalFreqPlane, .grow.movePalOfs, .grow.movePalOfsPlane,
      // .grow.movePalAge (how the age of the box effects the palette offset).
      // The effect for move X, Y and Z is achieved through swizzle of the moveX, moveY & moveZ in following way:
      // (all values from green channel)
      //  if palette 0.0 >= .g < 0.333 then moveXYZ (XY plane)
      //  if palette 0.333 >= .g < 0.667 then moveZXY (XZ plane)
      //  if palette 0.667 >= .g <= 1.0 then moveYZX (YZ plane)
      TextureImage { textureUnit: 3; file: "../../images/meteor.png"}
      TextureImage { textureUnit: 3; file: "../../images/palette_shot5.png"}

      VariClock {
          id: boxGrowerSwipeTime
          clockSpeed: sync(boxGrower.name+".swipe.speed")
          reset: sync(boxGrower.name+".swipeSpeed.reset")
          triggerReset: sync(boxGrower.name+".swipeFade.trigger")
          resetTime: sync(boxGrower.name+".swipeSpeed.resetTime")
      }


      VariClock {
          id: boxGrowerSwipeFadeTime
          clockSpeed: sync(boxGrower.name+".swipe.fadeSpeed")
          reset: sync(boxGrower.name+".swipeSpeed.reset")
          triggerReset: sync(boxGrower.name+".swipeFade.trigger")
          resetTime: sync(boxGrower.name+".swipeSpeed.resetTime")
      }

      Trigger {
          id: boxSwipeFadeTrigger
          reset: sync(boxGrower.name+".swipeFade.trigger")
      }

      DrawTrans2 {
        id: drawTransBG; name: "grow"; emitIntervalMS: sync(boxGrower.name+".emitNewInterval");
        file: "mesh/tri4.lwo";
       // file: "mesh/dode.lwo";
       // file: "mesh/boxcut.lwo";
       // file: "mesh/adapt.obj";
       // file: "mesh/plane.x"
       //  file: "mesh/ball.lwo";

        syncBaseName: boxGrower.name

        transPack: true
        shaderVaryings: "uvec2 positionGI; uvec2 normalGI; uint uvGI; uvec2 tangentGI; uvec2 origCenterGI; uvec2 genInfoGI; uvec2 emitInfoGI; uvec2 branchInfoGI;"
        zoomPercent: 1.0*sync("zoomPercent");
        drawBlendMode: "normal"
        // transShader contains both emit & advance code

        transShader: "branchTransInt";
        transParams: ParamGroup {
            ShaderParam { paramName: "g_discardEdgeLen"; paramValue: sync(boxGrower.name+".grow.discardEdgeLen") }
            ShaderParam { paramName: "g_maxDist"; paramValue: sync(boxGrower.name+".grow.maxDist") }
            ShaderParam { paramName: "g_branchRateMS"; paramValue: sync(boxGrower.name+".grow.branchRateMS") }
            ShaderParam { paramName: "g_branchRateVar"; paramValue: sync(boxGrower.name+".grow.branchRateVar") }
            ShaderParam { paramName: "g_branchRateVFreq"; paramValue: sync(boxGrower.name+".grow.branchRateVFreq") }
            ShaderParam { paramName: "g_branchMax"; paramValue: sync(boxGrower.name+".grow.maxBranch") }
            ShaderParam { paramName: "g_maxLevel"; paramValue: sync(boxGrower.name+".grow.maxLevel") }
            ShaderParam { paramName: "g_maxAge"; paramValue: sync(boxGrower.name+".grow.maxAgeSec") }
            ShaderParam { paramName: "g_maxEmitTime"; paramValue: sync(boxGrower.name+".grow.maxEmitTimeSec") }
            ShaderParam { paramName: "g_branchMoveFreq"; paramValue: sync(boxGrower.name+".grow.moveFreq") }
            ShaderParam { paramName: "g_branchMoveFreqVar"; paramValue: sync(boxGrower.name+".grow.moveFreqVar") }
            ShaderParam { paramName: "g_branchGrowScale"; paramValue: sync(boxGrower.name+".grow.sca") }
            ShaderParam { paramName: "g_branchGrowScaleVar"; paramValue: sync(boxGrower.name+".grow.scaVar") }
            ShaderParam { paramName: "g_branchGrowScaleVarFreq"; paramValue: sync(boxGrower.name+".grow.scaVarFreq") }
            ShaderParam { paramName: "g_branchGrowScaleVarPhase"; paramValue: sync(boxGrower.name+".grow.scaVarPhase") }
            ShaderParam { paramName: "g_branchMove"; paramValueVec4: sync(boxGrower.name+".grow.move")*0.10+","+sync(boxGrower.name+".grow.moveX")*0.10+","+sync(boxGrower.name+".grow.moveY")*0.10+","+sync(boxGrower.name+".grow.moveZ")*0.10 }
            ShaderParam { paramName: "g_branchMovePal"; paramValueVec4: sync(boxGrower.name+".grow.movePalAmp")+","+sync(boxGrower.name+".grow.movePalAge")+","+sync(boxGrower.name+".grow.moveY")+","+sync(boxGrower.name+".grow.moveZ") }
            ShaderParam { paramName: "g_branchMovePalFreqOfs"; paramValueVec4: sync(boxGrower.name+".grow.movePalFreq")+","+sync(boxGrower.name+".grow.movePalFreqLevel")+","+sync(boxGrower.name+".grow.movePalOfs")+","+sync(boxGrower.name+".grow.movePalOfsLevel") }
            ShaderParam { paramName: "g_branchMovePerLevel"; paramValue: sync(boxGrower.name+".grow.movePerLevel")*0.10 }
            ShaderParam { paramName: "g_branchMoveMulLevel"; paramValue: sync(boxGrower.name+".grow.moveMulLevel") }
            ShaderParam { paramName: "g_branchMoveOfs"; paramValue: sync(boxGrower.name+".grow.moveOfs")*0.10 }
            ShaderParam { paramName: "g_branchMoveOfsPerLevel"; paramValue: sync(boxGrower.name+".grow.moveOfsPerLevel")*0.10 }
            ShaderParam { paramName: "g_branchScalePerLevel"; paramValue: sync(boxGrower.name+".grow.scalePerLevel") }
            ShaderParam { paramName: "g_emitRateMS"; paramValue: sync(boxGrower.name+".grow.emitRateMS") }
            ShaderParam { paramName: "g_branchRot1"; paramValue: sync(boxGrower.name+".grow.rot1") }
            ShaderParam { paramName: "g_branchRot2"; paramValue: sync(boxGrower.name+".grow.rot2") }
            ShaderParam { paramName: "g_branchRot1Level"; paramValue: sync(boxGrower.name+".grow.rot1Level") }
            ShaderParam { paramName: "g_branchRot2Level"; paramValue: sync(boxGrower.name+".grow.rot2Level") }
            ShaderParam { paramName: "g_branchAngle"; paramValueVec4: sync(boxGrower.name+".grow.branchAng")+","+sync(boxGrower.name+".grow.branchAngVar")+","+sync(boxGrower.name+".grow.branchAngVarFreq") }
            ShaderParam { paramName: "g_rotAmount"; paramValue: sync(boxGrower.name+".grow.rotAmount") }
            ShaderParam { paramName: "g_rotAmountLevel"; paramValue: sync(boxGrower.name+".grow.rotAmountLevel") }
            ShaderParam { paramName: "g_maxSca"; paramValue: sync(boxGrower.name+".grow.maxSca") }
            ShaderParam { paramName: "g_maxScaSmooth"; paramValue: sync(boxGrower.name+".grow.maxScaSmooth") }
            ShaderParam { paramName: "g_scaleMove"; paramValue: sync(boxGrower.name+".grow.moveScale") }
            ShaderParam { paramName: "g_maxScaMove"; paramValue: sync(boxGrower.name+".grow.maxScaMove") }
            ShaderParam { paramName: "g_maxScaMoveSmooth"; paramValue: sync(boxGrower.name+".grow.maxScaMoveSmooth") }
        }

        drawShader: "branchDrawInt";
        drawParams: ParamGroup {
            Pos { x: 0.0; y: 0.0; z: 0.0 }
            Rot { d: 0; ax: 1.0; ay: 0.0; az: 0.0 }
            Sca { s: 1.0; x: 1.0; y: 1.0; z: 1.0 }
            ShaderParam { paramName: "g_discardEdgeLen"; paramValue: sync(boxGrower.name+".grow.discardEdgeLen") }
            ShaderParam { paramName: "g_discardEdgeFade"; paramValue: 1.0-sync(boxGrower.name+".grow.discEdgeFade") }
            ShaderParam { paramName: "g_discardEdgeFadeSpeed"; paramValue: sync(boxGrower.name+".grow.discEdgeFadeSpeed") }
            ShaderParam { paramName: "g_bump"; paramValue: 1.0}
            ShaderParam { paramName: "g_texBrightness"; paramValue: 0.50 }
            ShaderParam { paramName: "g_texAmbient"; paramValue: 0.0 }
            ShaderParam { paramName: "g_uvScale"; paramValue: 1.0 }
            ShaderParam { paramName: "g_color"; paramValueVec4: "1.0, 1.0, 1.0, 1.0" }
            ShaderParam { paramName: "g_prevBlurAmount"; paramValue: 0.1*sync("prevBlurAmount") }
            ShaderParam { paramName: "g_bright"; paramValue: 1.0}
            ShaderParam { paramName: "g_palSwipeFreq"; paramValue: sync(boxGrower.name+".swipe.freq") }
            ShaderParam { paramName: "g_palSwipeOfs"; paramValue: sync(boxGrower.name+".swipe.ofs")+boxGrowerSwipeTime.time }
            ShaderParam { paramName: "g_palSwipeZero"; paramValue: sync(boxGrower.name+".swipe.zeroColor")}
            ShaderParam { paramName: "g_palSwipeIntensity"; paramValue: sync(boxGrower.name+".swipe.colIntensity")}
            ShaderParam { paramName: "g_palSwipeColorPow"; paramValue: sync(boxGrower.name+".swipe.colPow")}
            ShaderParam { paramName: "g_palSwipeFadeFreq"; paramValue: sync(boxGrower.name+".swipe.fadeFreq")}
            ShaderParam { paramName: "g_palSwipeFadeOfs"; paramValue: sync(boxGrower.name+".swipe.fadeOfs")+boxGrowerSwipeFadeTime.time}
            ShaderParam { paramName: "g_palSwipeFadePerc"; paramValue: sync(boxGrower.name+".swipe.fadeCutoff")}
            ShaderParam { paramName: "g_palSwipeTimeOfs"; paramValue: boxSwipeFadeTrigger.time }
            ShaderParam { paramName: "g_swipeRadAmp"; paramValue: sync(boxGrower.name+".swipe.radAmp") }

            ShaderParam { paramName: "g_agePalFreq"; paramValue: sync(boxGrower.name+".agePal.freq") }
            ShaderParam { paramName: "g_agePalOfs"; paramValue: sync(boxGrower.name+".agePal.ofs") }
            ShaderParam { paramName: "g_agePalIntensity"; paramValue: sync(boxGrower.name+".agePal.intensity") }

        }

        drawMesh: DrawMesh {
            // draw one bigger mesh
            file: drawTransBG.file; Pos { x: drawTransBG.er*Math.sin(drawTransBG.ki)+drawTransBG.pr*Math.cos(drawTransBG.kii*2.3); y: Math.abs(0.0*(Math.sin(drawTransBG.ki*0.9+Math.cos(drawTransBG.kii*1.5)))); z: drawTransBG.er*Math.cos(drawTransBG.ki)+drawTransBG.pr*Math.sin(drawTransBG.kii*3.43)}
            halfFloats: drawTransBG.transPack
            intPack: drawTransBG.transPack
            Rot { d: 0.0; ax: 1.0; ay: 1.0; az: 0.0 }
            // Pos { x: 10.0 }
            Sca { s: sync(boxGrower.name+".grow.emitMeshScale"); x: 1.0; y: 1.0; z: 1.0 }
            ShaderParam { paramName: "g_emit"; paramValue: 1.0}
            ShaderParam { paramName: "g_bright"; paramValue: drawTransBG.drawIndex%2 < 1 ? 1.0 : 1.0 }
            ShaderParam { paramName: "g_uvScale"; paramValue: 1.0}
            blendMode: "off"; depthTest: true; depthWrite: true; triggeredRender: true
            cullBack: true
            cull: true
            property real kic: drawTransBG.ki
          }
      }
  }

  Blit { textureRT: "depth"; blitRT: 1}
  PrevBlur {
      id: pb
      Connections {
          function clamp(v) {
              return Math.max(Math.min(v, 1.0), -1.0);
          }
          property real prevTi: 0.0
          target: demo; onFrameRendered: {
              var camAutoEnabled = sync("camera.autoMove.ON");
              var ti = demoTime();
              var deltaTime = (ti-prevTi);
              prevTi = ti;
              if (camAutoEnabled && deltaTime > 0.0) {
                  flyCam.camOfs.x += (-pb.getAvgPosX())*Math.pow(clamp(sync("camera.autoMove.acc")*sync("camera.autoMove.accX")), rocket.timeStepReal/16.67);
                  flyCam.camOfs.y += (-pb.getAvgPosY())*Math.pow(clamp(sync("camera.autoMove.acc")*sync("camera.autoMove.accY")), rocket.timeStepReal/16.67);
                  flyCam.camOfs.z += (-pb.getAvgPosZ())*Math.pow(clamp(sync("camera.autoMove.acc")*sync("camera.autoMove.accZ")), rocket.timeStepReal/16.67);
              }
              var k = Math.pow(0.95, rocket.timeStepReal/16.67);
              flyCam.camOfs.x *= k;
              flyCam.camOfs.y *= k;
              flyCam.camOfs.z *= k;

             // console.log("x:"+pb.getAvgPosX(), "y:"+pb.getAvgPosY(), "z:"+pb.getAvgPosZ());
          }
      }
  }

  WaterPartikles {
    id: wp; name: "waterPart"; drawEnabled: enabled; enabled: sync(wp.name+".ON"); emitShader: "smEmitter";
    emitMesh: DrawMesh {
        file: "mesh/kolkkus.x"; depthTest: true; depthWrite: true; blendMode: "off";
        // Shader params for particle emitting
        ShaderParam { paramName: "g_emitPercent"; paramValue: sync("waterPart.g_emitPercent")}
        // Shader params for mesh surface
        ShaderParam { paramName: "g_uvScale"; paramValue: 0.20 }
        ShaderParam { paramName: "g_texBrightness"; paramValue: 0.0 }
        ShaderParam { paramName: "g_prevAmount"; paramValue: 0.0 }
        ShaderParam { paramName: "g_prevBlurAmount"; paramValue: 0.0 }
        Pos { x: 2.0; y: 6.0; z: 0.50}
        Rot { d: 0.0; ax: 1.0; ay: 0.0; az: 0.0 }
        Sca { s: sync("waterPart.g_emitterSize"); x: 1.0; y: 1.0; z: 1.0 }
      }
  }

  Reflect { }
  Fog {
     textureBG: "bgBall"
  }

  // postprocs
  Tonemap { }
  Glow { }
  Blit { textureRT: "prev" }
  Vignette { }
  Coords { }
}
